//
// pageTest.java
//
import oracle.sql.*; 
import oracle.jdbc.*; 

import oracle.xml.sql.*; 
import oracle.xml.sql.query.*; 
import oracle.xml.sql.dataset.*; 
import oracle.xml.sql.docgen.*; 

import java.sql.*; 
import java.io.*; 

public class pageTest
{
  Connection conn;
  OracleXMLQuery qry;
  Statement stmt;
  ResultSet rset;
  int lastRow = 0;

  public static void main(String[] argv)
  {
    String str;
    try
    {
      pageTest test = new pageTest("SELECT * FROM employees");
      int i = 0;
// Get the data one page at a time
      while ((str = test.getResult(i,i+10))!= null)
      {
        System.out.println(str);
        i+= 10;
      } // end while
      test.close();
    } // end try
    catch (Exception e )
    {
      //e.printStackTrace(System.out);
    }
  } // end main

  public pageTest(String sqlQuery)
  {
    try
    {
      conn  = getConnection("hr","hr");
      stmt = conn.createStatement();// create a statement
      ResultSet rset = stmt.executeQuery(sqlQuery); // get the result set
      qry = new OracleXMLQuery(conn,rset); // create a query object
      // configure the query object
      qry.keepObjectOpen(true);
      qry.setRaiseNoRowsException(true);
      qry.setRaiseException(true);
    }
    catch (Exception e )
    {
      e.printStackTrace(System.out);
    }
  } // end pageTest()
  
// Get the connection given the user name and password
  private static Connection getConnection(String user, String passwd)
    throws SQLException
  {
    DriverManager.registerDriver(new oracle.jdbc.OracleDriver());
    Connection conn =
      DriverManager.getConnection("jdbc:oracle:oci:@",user,passwd);
    return conn;
  }

// Returns the next XML page
  public String getResult(int startRow, int endRow)
  {
    qry.setMaxRows(endRow-startRow); // set the max # of rows to retrieve
    return qry.getXMLString();
  }

// Method to still perform the next page. 
  public String nextPage()
  {
    String result = getResult(lastRow,lastRow+10);
    lastRow+= 10;
    return result;
  }

  public void close() throws SQLException
  {
    stmt.close();   // close the statement..
    conn.close();   // close the connection
    qry.close();    // close the query..
  }
} // end pageTest
